// AppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "App.h"
#include "AppDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAppDlg dialog




CAppDlg::CAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAppDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT2, edit1);
	DDX_Control(pDX, IDC_EDIT3, edit2);
	DDX_Control(pDX, IDC_EDIT4, edit3);
	DDX_Control(pDX, IDC_PROGRESS1, progress1);
}

BEGIN_MESSAGE_MAP(CAppDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
//	ON_WM_POWERBROADCAST()
ON_WM_POWERBROADCAST()
END_MESSAGE_MAP()


// CAppDlg message handlers

BOOL CAppDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	progress1.SetRange(0,100);

	const int poziomNiski = 33;
	const int poziomWysoki = 66;

	SYSTEM_POWER_STATUS stan;
	GetSystemPowerStatus(&stan);

	switch(stan.ACLineStatus)
	{
		case 0:edit1.SetWindowTextW(L"odczone");break;
		case 1:edit1.SetWindowTextW(L"zaczone");break;
		case 255:edit1.SetWindowTextW(L"stan nieznany");break;
		default:edit1.SetWindowTextW(L"stan nieporoznawalny");break;
	}

	edit2.SetWindowTextW(L"uywana");
	if((stan.BatteryFlag & 256) == 256) edit2.SetWindowTextW(L"nieznany");
	if((stan.BatteryFlag & 128) == 128) edit2.SetWindowTextW(L"brak");
	if((stan.BatteryFlag & 8) == 8) edit2.SetWindowTextW(L"brak");

	bool bateriaObecna = ((stan.BatteryFlag & 128) != 128);
	CString obecnyStan ;
	edit2.GetWindowTextW(obecnyStan);
	if(bateriaObecna)
	{
		if((stan.BatteryFlag & 1) == 1) obecnyStan.Append(L", wysoki");
		if((stan.BatteryFlag & 2) == 2) obecnyStan.Append(L", niski");
		if((stan.BatteryFlag & 4) == 4) obecnyStan.Append(L", krytyczny");
		edit2.SetWindowTextW(obecnyStan);
	}

	if(stan.BatteryLifePercent == 255)
	{
		edit3.SetWindowTextW(L"nieznany");
	}
	else
	{
		CString procentBaterii;
		procentBaterii.AppendFormat(L"%d%%",stan.BatteryLifePercent);
		edit3.SetWindowTextW(procentBaterii);
		progress1.SetPos(stan.BatteryLifePercent);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAppDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAppDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

UINT CAppDlg::OnPowerBroadcast(UINT nPowerEvent, UINT nEventData)
{
	OnInitDialog();
	return CDialog::OnPowerBroadcast(nPowerEvent, nEventData);
}
